/************ X OAuth2 (PKCE) 設定 ************/

CLIENT_ID = "YOUR_CLIENT_ID_HERE";
CLIENT_SECRET = "YOUR_CLIENT_SECRET_HERE";
const SCOPES = [
  'tweet.read',
  'tweet.write',
  'users.read',
  'offline.access',
];

const AUTH_URL  = 'https://twitter.com/i/oauth2/authorize';
const TOKEN_URL = 'https://api.twitter.com/2/oauth2/token';

/************ スプレッドシート設定 ************/

const SHEET_NAME = '投稿メッセージリスト';

/************************************************
 * PKCE: code_verifier / code_challenge 生成
 ************************************************/
function pkceChallengeVerifier() {
  const userProps = PropertiesService.getUserProperties();

  if (!userProps.getProperty('code_verifier')) {
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~';
    let verifier = '';
    for (let i = 0; i < 64; i++) {
      verifier += chars.charAt(Math.floor(Math.random() * chars.length));
    }

    const sha256 = Utilities.computeDigest(
      Utilities.DigestAlgorithm.SHA_256,
      verifier,
      Utilities.Charset.UTF_8
    );
    let challenge = Utilities.base64Encode(sha256)
      .replace(/\+/g, '-')
      .replace(/\//g, '_')
      .replace(/=+$/, '');

    userProps.setProperty('code_verifier', verifier);
    userProps.setProperty('code_challenge', challenge);
  }
}

/************************************************
 * OAuth2 サービス（X / Twitter PKCE）
 * ※ このブロックは一切変更していません
 ************************************************/
function getTwitterService() {
  pkceChallengeVerifier();
  const userProps = PropertiesService.getUserProperties();
  const codeVerifier  = userProps.getProperty('code_verifier');
  const codeChallenge = userProps.getProperty('code_challenge');

  return OAuth2.createService('X')
    .setAuthorizationBaseUrl(AUTH_URL)
    .setTokenUrl(TOKEN_URL + '?code_verifier=' + encodeURIComponent(codeVerifier))
    .setClientId(CLIENT_ID)
    .setClientSecret(CLIENT_SECRET)
    .setCallbackFunction('authCallback')
    .setPropertyStore(userProps)
    .setScope(SCOPES.join(' '))
    .setParam('response_type', 'code')
    .setParam('code_challenge_method', 'S256')
    .setParam('code_challenge', codeChallenge)
    .setTokenHeaders({
      Authorization: 'Basic ' + Utilities.base64Encode(CLIENT_ID + ':' + CLIENT_SECRET),
      'Content-Type': 'application/x-www-form-urlencoded',
    });
}

/************************************************
 * 初回認証フロー
 ************************************************/
function authorize() {
  const service = getTwitterService();
  if (!service.hasAccess()) {
    const url = service.getAuthorizationUrl();
    Logger.log('この URL を開いて X で認証してください:\n' + url);
  }
}

/************************************************
 * X からのコールバック
 ************************************************/
function authCallback(e) {
  const service = getTwitterService();
  const authorized = service.handleCallback(e);
  return HtmlService.createHtmlOutput(
    authorized ? 'X の認証に成功しました。このタブは閉じてOKです。'
               : 'X の認証に失敗しました。'
  );
}



/********************************
 * 本日日付（1〜31）と一致する行を投稿
 * 時間別投稿
 ********************************/
function scheduledTweet() {
  const sheet = SpreadsheetApp.getActiveSpreadsheet().getSheetByName(SHEET_NAME);
  const values = sheet.getDataRange().getValues();
  const todayDay = new Date().getDate();
  const nowHour = new Date().getHours();
  const service = getTwitterService();

  if (!service.hasAccess()) {
    Logger.log("OAuth2.0認証が必要です。main()を先に実行してください。");
    return;
  }

  // 時間帯ごとの列インデックス設定
  let textCol = null;
  let imageCol = null;

  if (nowHour >= 5 && nowHour < 12) {
    textCol = 1; // B列
  } else if (nowHour >= 12 && nowHour < 15) {
    textCol = 2; // C列
  } else if (nowHour >= 15 && nowHour < 18) {
    textCol = 3; // D列
  } else if (nowHour >= 18 && nowHour < 24) {
    textCol = 4; // E列
  } else {
    Logger.log("この時間帯には投稿が設定されていません。");
    return;
  }

  for (let i = 1; i < values.length; i++) {
    const rowDay = parseInt(values[i][0]);
    if (rowDay !== todayDay) continue;

    const tweetText = values[i][textCol];
    if (!tweetText || tweetText.toString().trim() === "") {
      Logger.log("ツイート本文が空欄のためスキップ（行 " + (i + 1) + "）");
      continue;
    }

    const payload = { text: tweetText };

    const response = UrlFetchApp.fetch('https://api.twitter.com/2/tweets', {
      method: 'post',
      contentType: 'application/json',
      headers: { Authorization: 'Bearer ' + service.getAccessToken() },
      payload: JSON.stringify(payload),
      muteHttpExceptions: true
    });

    Logger.log("投稿結果: " + response.getContentText());
  }
}

function resetAuth(){ getTwitterService().reset(); }